function ajax_search(obj, value) {
  const search_box = document.getElementsByClassName('ajax_search_box')[0];

  if (value) {
    Progress();
    show_();
    data = { value: value }
    $.ajax({
      type: "get",
      url: "/search/",
      data: data,
      success: function (response) {
        Progress(false);
        if (response) {
          var products_place = document.getElementsByClassName('products__')[0];
          products_place.innerHTML = '';
          var brands_place = document.getElementsByClassName('brands__')[0];
          brands_place.innerHTML = '';
          var blogs_place = document.getElementsByClassName('blogs__')[0];
          blogs_place.innerHTML = '';
          if (response.product.count > 0) {
            var html = '<div class="search_header d-flex justify-content-between w-100"><span class="sm-font">محصولات <span class="xs-font">(' + response.product.count + ' نتیجه)</span></span><a href="/search/result_for/page=1?search=' + value + '"><span class="xs-font " font_gold>مشاهده همه</span></a></div>';
            products_place.insertAdjacentHTML('afterbegin', html);
            html = '<div class="search_body d-flex"><div class="row w-100 products__items"></div></div>';
            products_place.insertAdjacentHTML('beforeend', html);
            var products_items_place = document.getElementsByClassName('products__items')[0];
            let items = response.product.items;
            for (let i = 0; i < items.length; i++) {
              html = '<div class="col-xl-6"><a href="/shop/product_detail/' + items[i].slug + '"><div class="item d-flex mt-2 border-bottom rounded p-2"><div class="image border rounded p-2"><img style="max-height: 56px;height: 56px;" class="rounded" src="' + items[i].cover_url + '" alt=""></div><h6 class="sm-font mr-2 lg-line-height text-right">' + items[i].name + '<br><span class="md-font text-dark float-left"><b>' + items[i].price + '</b> <span class="xs-font text-secondary">(ریال)</span></span></h6></div></a></div>';
              products_items_place.insertAdjacentHTML('beforeend', html);
            }
          }
          if (response.brands.count > 0) {
            var html = '<div class="search_header d-flex justify-content-between w-100"><span class="sm-font">برند <span class="xs-font">(' + response.brands.count + ' نتیجه)</span></span></div>';
            brands_place.insertAdjacentHTML('afterbegin', html);
            html = '<div class="search_body d-flex brands__items" scroll_card></div>';
            brands_place.insertAdjacentHTML('beforeend', html);
            var brands_items_place = document.getElementsByClassName('brands__items')[0];
            let items = response.brands.items;
            for (let i = 0; i < items.length; i++) {
              html = '<a href="/brand/' + items[i].slug + '/page=1"><h6 class="item mt-2 bg-white shadow-sm rounded py-2 px-3 ml-2 sm-font">' + items[i].name + '</h6></a>'
              brands_items_place.insertAdjacentHTML('beforeend', html);
            }
          }
          if (response.blogs.count > 0) {
            var html = '<div class="search_header d-flex justify-content-between w-100"><span class="sm-font">بلاگ <span class="xs-font">(' + response.blogs.count + ' نتیجه)</span></span></div>';
            blogs_place.insertAdjacentHTML('afterbegin', html);
            html = '<div class="search_body d-flex"><div class="row my-3 blogs__items"></div></div>';
            blogs_place.insertAdjacentHTML('beforeend', html);
            var blogs_items_place = document.getElementsByClassName('blogs__items')[0];
            let items = response.blogs.items;
            for (let i = 0; i < items.length; i++) {
              html = '<div class="col-6 col-xl-4"><article class="blog_card w-100 position-relative mb-3"><a href="/blog/'+items[i].slug+'"><div class="header"><img class="w-100" src="'+items[i].cover_url+'" ></div><h1 class="md-font">'+items[i].name+'</h1><p class="sm-4"></p><div class="create_at float-bottom position-absolute" style="bottom:4px;left:12px"><span>'+items[i].date+'</span><i class="far fa-calendar mr-2"></i></div></a></article></div>'
              blogs_items_place.insertAdjacentHTML('beforeend', html);
            }
          }
        }
      },
      error: function () {

      },
    });
  } else {
    Progress(false);
    show_(false);
  }



  function show_(show = true) {
    if (show) {
      search_box.classList.add('show');
    } else {
      search_box.classList.remove('show');
    }
  }
}